/**
 * Program IDL in camelCase format in order to be used in JS/TS.
 *
 * Note that this is only a type helper and is not the actual IDL. The original
 * IDL can be found at `target/idl/validator_registry.json`.
 */
export type ValidatorRegistry = {
  "address": "EgUbYv1coMTXsdRc5HBqTv32SNhTcsRS1nPiUDw5LbQK",
  "metadata": {
    "name": "validatorRegistry",
    "version": "0.1.0",
    "spec": "0.1.0",
    "description": "Created with Anchor"
  },
  "instructions": [
    {
      "name": "addValidator",
      "discriminator": [
        250,
        113,
        53,
        54,
        141,
        117,
        215,
        185
      ],
      "accounts": [
        {
          "name": "authority",
          "signer": true
        },
        {
          "name": "validatorRegistry",
          "writable": true
        }
      ],
      "args": [
        {
          "name": "voteAccount",
          "type": "pubkey"
        },
        {
          "name": "name",
          "type": "string"
        },
        {
          "name": "performanceScore",
          "type": "u32"
        }
      ]
    },
    {
      "name": "getValidators",
      "discriminator": [
        74,
        81,
        116,
        129,
        224,
        19,
        17,
        238
      ],
      "accounts": [
        {
          "name": "validatorRegistry"
        }
      ],
      "args": []
    },
    {
      "name": "initialize",
      "discriminator": [
        175,
        175,
        109,
        31,
        13,
        152,
        155,
        237
      ],
      "accounts": [
        {
          "name": "payer",
          "writable": true,
          "signer": true
        },
        {
          "name": "validatorRegistry",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  108,
                  105,
                  100,
                  97,
                  116,
                  111,
                  114,
                  95,
                  114,
                  101,
                  103,
                  105,
                  115,
                  116,
                  114,
                  121
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "authority",
          "type": "pubkey"
        }
      ]
    },
    {
      "name": "moveTransientToActive",
      "discriminator": [
        140,
        99,
        170,
        186,
        84,
        61,
        184,
        75
      ],
      "accounts": [
        {
          "name": "validatorRegistry",
          "writable": true
        }
      ],
      "args": [
        {
          "name": "voteAccount",
          "type": "pubkey"
        },
        {
          "name": "amount",
          "type": "u64"
        }
      ]
    },
    {
      "name": "syncValidatorScores",
      "discriminator": [
        10,
        26,
        245,
        222,
        183,
        46,
        70,
        181
      ],
      "accounts": [
        {
          "name": "authority",
          "signer": true
        },
        {
          "name": "validatorRegistry",
          "writable": true
        },
        {
          "name": "stakeControllerProgram"
        }
      ],
      "args": [
        {
          "name": "voteAccounts",
          "type": {
            "vec": "pubkey"
          }
        },
        {
          "name": "validatorMetrics",
          "type": {
            "vec": {
              "defined": {
                "name": "validatorMetrics"
              }
            }
          }
        }
      ]
    },
    {
      "name": "updateMaxResolvedStake",
      "discriminator": [
        241,
        21,
        28,
        14,
        58,
        11,
        76,
        44
      ],
      "accounts": [
        {
          "name": "validatorRegistry",
          "writable": true
        }
      ],
      "args": [
        {
          "name": "voteAccount",
          "type": "pubkey"
        },
        {
          "name": "newValue",
          "type": "u64"
        }
      ]
    },
    {
      "name": "updateValidatorInfo",
      "discriminator": [
        120,
        41,
        183,
        100,
        13,
        154,
        196,
        200
      ],
      "accounts": [
        {
          "name": "validatorRegistry",
          "writable": true
        }
      ],
      "args": [
        {
          "name": "voteAccount",
          "type": "pubkey"
        },
        {
          "name": "currentActiveStakeAmount",
          "type": {
            "option": "u64"
          }
        },
        {
          "name": "epochRewardAmount",
          "type": {
            "option": "u64"
          }
        },
        {
          "name": "transientActiveStakeAmount",
          "type": {
            "option": "u64"
          }
        },
        {
          "name": "epoch",
          "type": {
            "option": "u64"
          }
        },
        {
          "name": "performanceScore",
          "type": {
            "option": "u32"
          }
        }
      ]
    }
  ],
  "accounts": [
    {
      "name": "validatorRegistry",
      "discriminator": [
        168,
        113,
        195,
        186,
        62,
        121,
        163,
        230
      ]
    }
  ],
  "events": [
    {
      "name": "validatorsSyncedEvent",
      "discriminator": [
        119,
        121,
        49,
        120,
        230,
        132,
        109,
        214
      ]
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "unauthorized",
      "msg": "Unauthorized access"
    },
    {
      "code": 6001,
      "name": "maxValidatorsReached",
      "msg": "Maximum validators reached"
    },
    {
      "code": 6002,
      "name": "validatorAlreadyExists",
      "msg": "Validator already exists"
    },
    {
      "code": 6003,
      "name": "validatorNotFound",
      "msg": "Validator not found"
    },
    {
      "code": 6004,
      "name": "invalidStakeUpdateType",
      "msg": "Invalid stake update type"
    },
    {
      "code": 6005,
      "name": "invalidVoteAccount",
      "msg": "Invalid vote account provided"
    },
    {
      "code": 6006,
      "name": "invalidInputLength",
      "msg": "Invalid input length - all vectors must have same length"
    },
    {
      "code": 6007,
      "name": "invalidStakeAccount",
      "msg": "Invalid Stake Account"
    },
    {
      "code": 6008,
      "name": "arithmeticOverflow",
      "msg": "Arithmetic overflow"
    },
    {
      "code": 6009,
      "name": "insufficientTransientStake",
      "msg": "Insufficient transient stake"
    }
  ],
  "types": [
    {
      "name": "validatorInfo",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "voteAccount",
            "type": "pubkey"
          },
          {
            "name": "vpp",
            "type": "u32"
          },
          {
            "name": "currentActiveStake",
            "type": "u64"
          },
          {
            "name": "epochReward",
            "type": "u64"
          },
          {
            "name": "transientActiveStake",
            "type": "u64"
          },
          {
            "name": "lastChainSyncEpoch",
            "type": "u64"
          },
          {
            "name": "lastUpdatedSlot",
            "type": "u64"
          },
          {
            "name": "maxResolvedEpochDeactivations",
            "type": "u64"
          },
          {
            "name": "maxResolvedActivatingStake",
            "type": "u64"
          }
        ]
      }
    },
    {
      "name": "validatorMetrics",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "commission",
            "type": "u8"
          },
          {
            "name": "skipRateBps",
            "type": "u32"
          },
          {
            "name": "isDelinquent",
            "type": "bool"
          },
          {
            "name": "activatedStake",
            "type": "u64"
          }
        ]
      }
    },
    {
      "name": "validatorRegistry",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "authority",
            "type": "pubkey"
          },
          {
            "name": "validators",
            "type": {
              "vec": {
                "defined": {
                  "name": "validatorInfo"
                }
              }
            }
          },
          {
            "name": "lastUpdateEpoch",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "validatorsSyncedEvent",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "updatedCount",
            "type": "u32"
          },
          {
            "name": "notFoundCount",
            "type": "u32"
          },
          {
            "name": "epoch",
            "type": "u64"
          }
        ]
      }
    }
  ]
};
