/**
 * Program IDL in camelCase format in order to be used in JS/TS.
 *
 * Note that this is only a type helper and is not the actual IDL. The original
 * IDL can be found at `target/idl/validator_leaderboard.json`.
 */
export type ValidatorLeaderboard = {
  "address": "CYxrJjaraGmdVjnB6EDNyx73pz9Lk2dqpaVtysNo7EXj",
  "metadata": {
    "name": "validatorLeaderboard",
    "version": "0.1.0",
    "spec": "0.1.0",
    "description": "Created with Anchor"
  },
  "instructions": [
    {
      "name": "initialize",
      "discriminator": [
        175,
        175,
        109,
        31,
        13,
        152,
        155,
        237
      ],
      "accounts": [
        {
          "name": "authority",
          "writable": true,
          "signer": true
        },
        {
          "name": "leaderboardHead",
          "docs": [
            "HEAD node - points to the highest VPP validator"
          ],
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  101,
                  97,
                  100,
                  101,
                  114,
                  98,
                  111,
                  97,
                  114,
                  100,
                  95,
                  104,
                  101,
                  97,
                  100
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "updateCommission",
      "discriminator": [
        2,
        202,
        72,
        156,
        19,
        253,
        91,
        174
      ],
      "accounts": [
        {
          "name": "registrant",
          "writable": true,
          "signer": true
        },
        {
          "name": "voteAccount"
        },
        {
          "name": "validatorRecord",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  108,
                  105,
                  100,
                  97,
                  116,
                  111,
                  114
                ]
              },
              {
                "kind": "account",
                "path": "voteAccount"
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "updateTop10Cache",
      "discriminator": [
        0,
        35,
        58,
        64,
        74,
        12,
        249,
        209
      ],
      "accounts": [
        {
          "name": "payer",
          "writable": true,
          "signer": true
        },
        {
          "name": "cache",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  116,
                  111,
                  112,
                  95,
                  49,
                  48,
                  95,
                  99,
                  97,
                  99,
                  104,
                  101
                ]
              }
            ]
          }
        },
        {
          "name": "leaderboardHead",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  101,
                  97,
                  100,
                  101,
                  114,
                  98,
                  111,
                  97,
                  114,
                  100,
                  95,
                  104,
                  101,
                  97,
                  100
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "top10",
          "type": {
            "array": [
              "pubkey",
              10
            ]
          }
        }
      ]
    },
    {
      "name": "updateValidator",
      "discriminator": [
        105,
        192,
        4,
        98,
        236,
        115,
        108,
        192
      ],
      "accounts": [
        {
          "name": "registrant",
          "writable": true,
          "signer": true
        },
        {
          "name": "voteAccount"
        },
        {
          "name": "validatorRecord",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  108,
                  105,
                  100,
                  97,
                  116,
                  111,
                  114
                ]
              },
              {
                "kind": "account",
                "path": "voteAccount"
              }
            ]
          }
        },
        {
          "name": "leaderboardHead",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  101,
                  97,
                  100,
                  101,
                  114,
                  98,
                  111,
                  97,
                  114,
                  100,
                  95,
                  104,
                  101,
                  97,
                  100
                ]
              }
            ]
          }
        },
        {
          "name": "insertAfter",
          "writable": true,
          "optional": true
        },
        {
          "name": "insertBefore",
          "writable": true,
          "optional": true
        },
        {
          "name": "currentPrev",
          "writable": true,
          "optional": true
        },
        {
          "name": "currentNext",
          "writable": true,
          "optional": true
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "vpp",
          "type": "u64"
        }
      ]
    }
  ],
  "accounts": [
    {
      "name": "leaderboardHead",
      "discriminator": [
        159,
        158,
        16,
        9,
        41,
        114,
        23,
        157
      ]
    },
    {
      "name": "top10Cache",
      "discriminator": [
        112,
        78,
        189,
        26,
        143,
        41,
        15,
        81
      ]
    },
    {
      "name": "validatorRecord",
      "discriminator": [
        105,
        248,
        112,
        34,
        71,
        224,
        21,
        71
      ]
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "missingPreviousValidator",
      "msg": "Missing previous validator account"
    },
    {
      "code": 6001,
      "name": "missingNextValidator",
      "msg": "Missing next validator account"
    },
    {
      "code": 6002,
      "name": "invalidVppScore",
      "msg": "Invalid VPP score provided."
    },
    {
      "code": 6003,
      "name": "invalidInsertPosition",
      "msg": "Invalid insertion position."
    },
    {
      "code": 6004,
      "name": "invalidCurrentPrev",
      "msg": "Invalid current previous validator."
    },
    {
      "code": 6005,
      "name": "invalidCurrentNext",
      "msg": "Invalid current next validator."
    },
    {
      "code": 6006,
      "name": "invalidHeadValidator",
      "msg": "Head validator cannot have a previous validator"
    },
    {
      "code": 6007,
      "name": "invalidTailValidator",
      "msg": "Tail validator cannot have a next validator"
    },
    {
      "code": 6008,
      "name": "validatorNotInLeaderboard",
      "msg": "Cannot remove validator that is not in the leaderboard"
    },
    {
      "code": 6009,
      "name": "validatorAlreadyExists",
      "msg": "Validator already exists in the leaderboard"
    },
    {
      "code": 6010,
      "name": "overflow",
      "msg": "Arithmetic overflow"
    },
    {
      "code": 6011,
      "name": "invalidVoteAccount",
      "msg": "Invalid vote account - must be owned by vote program"
    },
    {
      "code": 6012,
      "name": "vppVerificationFailed",
      "msg": "VPP verification failed"
    },
    {
      "code": 6013,
      "name": "vppUnchanged",
      "msg": "VPP score unchanged - update not needed"
    },
    {
      "code": 6014,
      "name": "invalidAccountCount",
      "msg": "Invalid account count for top 10 verification"
    },
    {
      "code": 6015,
      "name": "invalidVppOrdering",
      "msg": "Validators not in correct VPP order"
    },
    {
      "code": 6016,
      "name": "brokenLinkage",
      "msg": "Broken linked list continuity"
    },
    {
      "code": 6017,
      "name": "commissionNotUpdated",
      "msg": "Commission must be updated for current epoch before updating validator"
    }
  ],
  "types": [
    {
      "name": "leaderboardHead",
      "docs": [
        "Special HEAD node for the linked list"
      ],
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "nextValidator",
            "type": "pubkey"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "top10Cache",
      "docs": [
        "Cache for the top 10 validators for fast CPI access"
      ],
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "validators",
            "type": {
              "array": [
                "pubkey",
                10
              ]
            }
          },
          {
            "name": "lastUpdatedSlot",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "validatorRecord",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "voteAccount",
            "type": "pubkey"
          },
          {
            "name": "creditsObserved",
            "type": "u64"
          },
          {
            "name": "commissionHistory",
            "type": {
              "array": [
                "u8",
                10
              ]
            }
          },
          {
            "name": "commissionIndex",
            "type": "u8"
          },
          {
            "name": "lastCommissionUpdate",
            "type": "u64"
          },
          {
            "name": "epoch",
            "type": "u64"
          },
          {
            "name": "slot",
            "type": "u64"
          },
          {
            "name": "performance",
            "type": "u64"
          },
          {
            "name": "stake",
            "type": "u64"
          },
          {
            "name": "registrant",
            "type": "pubkey"
          },
          {
            "name": "wireOperator",
            "type": "bool"
          },
          {
            "name": "nextValidator",
            "type": "pubkey"
          },
          {
            "name": "prevValidator",
            "type": "pubkey"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    }
  ]
};
