/**
 * Program IDL in camelCase format in order to be used in JS/TS.
 *
 * Note that this is only a type helper and is not the actual IDL. The original
 * IDL can be found at `target/idl/stake_controller.json`.
 */
export type StakeController = {
  "address": "4Ab1SwV6RPUN5Btnf95qvQCyNVR3iHnXjnMYaKsgimTp",
  "metadata": {
    "name": "stakeController",
    "version": "0.1.0",
    "spec": "0.1.0"
  },
  "instructions": [
    {
      "name": "calculateCompoundGrowth",
      "docs": [
        "Calculate compound growth for an amount using pay rate history - can be called via CPI"
      ],
      "discriminator": [
        105,
        2,
        145,
        40,
        175,
        163,
        215,
        99
      ],
      "accounts": [
        {
          "name": "payRateHistory",
          "docs": [
            "The pay rate history account containing historical rates"
          ],
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  114,
                  97,
                  116,
                  101,
                  95,
                  104,
                  105,
                  115,
                  116,
                  111,
                  114,
                  121
                ]
              }
            ]
          }
        }
      ],
      "args": [
        {
          "name": "initialAmount",
          "type": "u64"
        },
        {
          "name": "sinceTimestamp",
          "type": "i64"
        }
      ],
      "returns": "u64"
    },
    {
      "name": "closeGlobalStakeInfo",
      "docs": [
        "Close the global stake info account (for migration)"
      ],
      "discriminator": [
        110,
        69,
        4,
        217,
        6,
        177,
        230,
        121
      ],
      "accounts": [
        {
          "name": "admin",
          "writable": true,
          "signer": true
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        }
      ],
      "args": []
    },
    {
      "name": "depositToReserve",
      "discriminator": [
        8,
        79,
        123,
        129,
        146,
        140,
        178,
        128
      ],
      "accounts": [
        {
          "name": "depositor",
          "writable": true,
          "signer": true
        },
        {
          "name": "reservePool",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  114,
                  101,
                  115,
                  101,
                  114,
                  118,
                  101,
                  95,
                  112,
                  111,
                  111,
                  108
                ]
              }
            ]
          }
        },
        {
          "name": "vault",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  117,
                  108,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "ephemeralStake",
          "writable": true
        },
        {
          "name": "controllerState",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  99,
                  111,
                  110,
                  116,
                  114,
                  111,
                  108,
                  108,
                  101,
                  114
                ]
              }
            ]
          }
        },
        {
          "name": "stakeProgram"
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "clock",
          "address": "SysvarC1ock11111111111111111111111111111111"
        },
        {
          "name": "stakeHistory"
        },
        {
          "name": "rent",
          "address": "SysvarRent111111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "amount",
          "type": "u64"
        },
        {
          "name": "seed",
          "type": "u32"
        }
      ]
    },
    {
      "name": "distributeFromReserve",
      "discriminator": [
        204,
        157,
        72,
        30,
        26,
        149,
        166,
        166
      ],
      "accounts": [
        {
          "name": "reservePool",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  114,
                  101,
                  115,
                  101,
                  114,
                  118,
                  101,
                  95,
                  112,
                  111,
                  111,
                  108
                ]
              }
            ]
          }
        },
        {
          "name": "vault",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  117,
                  108,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        },
        {
          "name": "validatorRegistry",
          "writable": true
        },
        {
          "name": "validatorRegistryProgram",
          "address": "EgUbYv1coMTXsdRc5HBqTv32SNhTcsRS1nPiUDw5LbQK"
        },
        {
          "name": "stakeProgram"
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "clock",
          "address": "SysvarC1ock11111111111111111111111111111111"
        },
        {
          "name": "stakeHistory"
        },
        {
          "name": "stakeConfig"
        },
        {
          "name": "rent",
          "address": "SysvarRent111111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "validatorsCount",
          "type": "u8"
        }
      ]
    },
    {
      "name": "getAveragePayRate",
      "docs": [
        "Gets the average pay rate from the last X entries (default 5), excluding zero values",
        "Can be called via CPI or locally for yield calculations"
      ],
      "discriminator": [
        28,
        24,
        109,
        124,
        61,
        26,
        31,
        242
      ],
      "accounts": [
        {
          "name": "payRateHistory",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  114,
                  97,
                  116,
                  101,
                  95,
                  104,
                  105,
                  115,
                  116,
                  111,
                  114,
                  121
                ]
              }
            ]
          }
        }
      ],
      "args": [
        {
          "name": "count",
          "type": {
            "option": "u8"
          }
        }
      ],
      "returns": "u64"
    },
    {
      "name": "incrementTotalFeesDeposited",
      "docs": [
        "Increment total fees deposited - can be called via CPI"
      ],
      "discriminator": [
        19,
        133,
        72,
        151,
        103,
        9,
        19,
        202
      ],
      "accounts": [
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        }
      ],
      "args": [
        {
          "name": "amount",
          "type": "u64"
        }
      ]
    },
    {
      "name": "initBucket",
      "docs": [
        "Initialize the liqSOL bucket by creating its associated token account"
      ],
      "discriminator": [
        237,
        69,
        61,
        218,
        18,
        60,
        21,
        236
      ],
      "accounts": [
        {
          "name": "admin",
          "writable": true,
          "signer": true
        },
        {
          "name": "bucketAuthority",
          "docs": [
            "The bucket authority PDA that will own the token account"
          ],
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  105,
                  113,
                  115,
                  111,
                  108,
                  95,
                  98,
                  117,
                  99,
                  107,
                  101,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "bucketTokenAccount",
          "docs": [
            "The bucket's associated token account to be created"
          ],
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "account",
                "path": "bucketAuthority"
              },
              {
                "kind": "account",
                "path": "tokenProgram"
              },
              {
                "kind": "account",
                "path": "liqsolMint"
              }
            ],
            "program": {
              "kind": "const",
              "value": [
                140,
                151,
                37,
                143,
                78,
                36,
                137,
                241,
                187,
                61,
                16,
                41,
                20,
                142,
                13,
                131,
                11,
                90,
                19,
                153,
                218,
                255,
                16,
                132,
                4,
                142,
                123,
                216,
                219,
                233,
                248,
                89
              ]
            }
          }
        },
        {
          "name": "liqsolMint",
          "docs": [
            "The liqSOL token mint"
          ]
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "tokenProgram"
        },
        {
          "name": "associatedTokenProgram",
          "address": "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL"
        }
      ],
      "args": []
    },
    {
      "name": "initialize",
      "discriminator": [
        175,
        175,
        109,
        31,
        13,
        152,
        155,
        237
      ],
      "accounts": [
        {
          "name": "controllerState",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  99,
                  111,
                  110,
                  116,
                  114,
                  111,
                  108,
                  108,
                  101,
                  114
                ]
              }
            ]
          }
        },
        {
          "name": "payer",
          "writable": true,
          "signer": true
        },
        {
          "name": "authority",
          "signer": true
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "initializeGlobalStakeInfo",
      "discriminator": [
        1,
        203,
        117,
        158,
        152,
        195,
        249,
        110
      ],
      "accounts": [
        {
          "name": "admin",
          "writable": true,
          "signer": true
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "initializePayCycle",
      "discriminator": [
        1,
        184,
        249,
        179,
        11,
        182,
        239,
        224
      ],
      "accounts": [
        {
          "name": "admin",
          "writable": true,
          "signer": true
        },
        {
          "name": "payCycle",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  99,
                  121,
                  99,
                  108,
                  101
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "initializePayRateHistory",
      "discriminator": [
        157,
        190,
        74,
        135,
        91,
        232,
        250,
        122
      ],
      "accounts": [
        {
          "name": "admin",
          "writable": true,
          "signer": true
        },
        {
          "name": "payRateHistory",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  114,
                  97,
                  116,
                  101,
                  95,
                  104,
                  105,
                  115,
                  116,
                  111,
                  114,
                  121
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "initializeReservePool",
      "discriminator": [
        4,
        7,
        171,
        131,
        156,
        172,
        150,
        220
      ],
      "accounts": [
        {
          "name": "reservePool",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  114,
                  101,
                  115,
                  101,
                  114,
                  118,
                  101,
                  95,
                  112,
                  111,
                  111,
                  108
                ]
              }
            ]
          }
        },
        {
          "name": "vault",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  117,
                  108,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "payer",
          "writable": true,
          "signer": true
        },
        {
          "name": "controllerState",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  99,
                  111,
                  110,
                  116,
                  114,
                  111,
                  108,
                  108,
                  101,
                  114
                ]
              }
            ]
          }
        },
        {
          "name": "stakeProgram",
          "address": "Stake11111111111111111111111111111111111111"
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "rent",
          "address": "SysvarRent111111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "initializeVault",
      "discriminator": [
        48,
        191,
        163,
        44,
        71,
        129,
        63,
        164
      ],
      "accounts": [
        {
          "name": "vault",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  117,
                  108,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "payer",
          "writable": true,
          "signer": true
        },
        {
          "name": "controllerState",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  99,
                  111,
                  110,
                  116,
                  114,
                  111,
                  108,
                  108,
                  101,
                  114
                ]
              }
            ]
          }
        },
        {
          "name": "treasuryProgram",
          "address": "98srSwC7RPw2BjUQE5oTuQMEhdWJ2GEK8GBLB4Ei2Awm"
        },
        {
          "name": "treasury",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  116,
                  114,
                  101,
                  97,
                  115,
                  117,
                  114,
                  121
                ]
              }
            ],
            "program": {
              "kind": "account",
              "path": "treasuryProgram"
            }
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "maintenanceMergeTransients",
      "discriminator": [
        171,
        33,
        27,
        133,
        97,
        62,
        213,
        96
      ],
      "accounts": [
        {
          "name": "admin",
          "signer": true
        },
        {
          "name": "vault",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  118,
                  97,
                  117,
                  108,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "validatorRegistry",
          "writable": true
        },
        {
          "name": "validatorRegistryProgram",
          "address": "EgUbYv1coMTXsdRc5HBqTv32SNhTcsRS1nPiUDw5LbQK"
        },
        {
          "name": "stakeProgram",
          "address": "Stake11111111111111111111111111111111111111"
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "clock",
          "address": "SysvarC1ock11111111111111111111111111111111"
        },
        {
          "name": "stakeHistory"
        },
        {
          "name": "rent",
          "address": "SysvarRent111111111111111111111111111111111"
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        }
      ],
      "args": [
        {
          "name": "voteAccount",
          "type": "pubkey"
        },
        {
          "name": "startEpoch",
          "type": "u64"
        }
      ]
    },
    {
      "name": "processPayCycle",
      "docs": [
        "Processes yield payments based on epoch progression and global stake data",
        "Calculates yield amount proportional to time elapsed and handles epoch transitions"
      ],
      "discriminator": [
        98,
        183,
        240,
        247,
        39,
        248,
        198,
        224
      ],
      "accounts": [
        {
          "name": "admin",
          "signer": true
        },
        {
          "name": "payCycle",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  99,
                  121,
                  99,
                  108,
                  101
                ]
              }
            ]
          }
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        },
        {
          "name": "payRateHistory",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  114,
                  97,
                  116,
                  101,
                  95,
                  104,
                  105,
                  115,
                  116,
                  111,
                  114,
                  121
                ]
              }
            ]
          }
        },
        {
          "name": "distributionState",
          "docs": [
            "The distribution state account from the distribution program"
          ],
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  100,
                  105,
                  115,
                  116,
                  114,
                  105,
                  98,
                  117,
                  116,
                  105,
                  111,
                  110,
                  95,
                  115,
                  116,
                  97,
                  116,
                  101
                ]
              }
            ],
            "program": {
              "kind": "const",
              "value": [
                102,
                164,
                181,
                150,
                80,
                7,
                111,
                173,
                226,
                222,
                223,
                68,
                20,
                191,
                248,
                95,
                171,
                85,
                102,
                94,
                79,
                176,
                10,
                5,
                127,
                225,
                78,
                61,
                234,
                210,
                47,
                121
              ]
            }
          }
        },
        {
          "name": "liqsolMint",
          "docs": [
            "The liqSOL token mint (Token-2022 compatible)"
          ],
          "writable": true
        },
        {
          "name": "bucketTokenAccount",
          "docs": [
            "The bucket's token account to receive minted liqSOL"
          ],
          "writable": true
        },
        {
          "name": "programAuthority",
          "docs": [
            "The stake controller authority PDA that will authorize the minting"
          ],
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  99,
                  111,
                  110,
                  116,
                  114,
                  111,
                  108,
                  108,
                  101,
                  114
                ]
              }
            ]
          }
        },
        {
          "name": "mintAuthority",
          "docs": [
            "The mint authority PDA from liq-sol-token program"
          ]
        },
        {
          "name": "liqsolProgram",
          "docs": [
            "The liq-sol-token program for minting"
          ],
          "address": "5MRFSLCkXPEzfR6gkcZCVttq9g83mMUHyTZ85Z3TSpvU"
        },
        {
          "name": "tokenProgram",
          "docs": [
            "Token program (Token2022)"
          ]
        },
        {
          "name": "instructions",
          "address": "Sysvar1nstructions1111111111111111111111111"
        }
      ],
      "args": []
    },
    {
      "name": "syncValidatorStakes",
      "discriminator": [
        40,
        56,
        118,
        52,
        20,
        213,
        229,
        135
      ],
      "accounts": [
        {
          "name": "admin",
          "signer": true
        },
        {
          "name": "mainValidatorStake",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  109,
                  97,
                  105,
                  110,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101
                ]
              },
              {
                "kind": "arg",
                "path": "validator"
              }
            ]
          }
        },
        {
          "name": "validatorRegistry",
          "writable": true
        },
        {
          "name": "validatorRegistryProgram"
        },
        {
          "name": "stakeHistory"
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        }
      ],
      "args": [
        {
          "name": "validator",
          "type": "pubkey"
        }
      ]
    },
    {
      "name": "transferFromBucket",
      "docs": [
        "Transfer liqSOL from the bucket to a destination wallet"
      ],
      "discriminator": [
        3,
        165,
        191,
        199,
        242,
        233,
        248,
        16
      ],
      "accounts": [
        {
          "name": "admin",
          "signer": true
        },
        {
          "name": "bucketAuthority",
          "docs": [
            "The bucket authority PDA that owns the token account"
          ],
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  105,
                  113,
                  115,
                  111,
                  108,
                  95,
                  98,
                  117,
                  99,
                  107,
                  101,
                  116
                ]
              }
            ]
          }
        },
        {
          "name": "bucketTokenAccount",
          "docs": [
            "The bucket's token account holding liqSOL"
          ],
          "writable": true
        },
        {
          "name": "destinationTokenAccount",
          "docs": [
            "Destination token account to send liqSOL to"
          ],
          "writable": true
        },
        {
          "name": "mint",
          "docs": [
            "The liqSOL mint"
          ]
        },
        {
          "name": "tokenProgram"
        }
      ],
      "args": [
        {
          "name": "amount",
          "type": "u64"
        }
      ]
    },
    {
      "name": "updateGlobalStakeInfo",
      "discriminator": [
        16,
        246,
        76,
        203,
        160,
        194,
        10,
        93
      ],
      "accounts": [
        {
          "name": "admin",
          "signer": true
        },
        {
          "name": "globalStakeInfo",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  103,
                  108,
                  111,
                  98,
                  97,
                  108,
                  95,
                  115,
                  116,
                  97,
                  107,
                  101,
                  95,
                  105,
                  110,
                  102,
                  111
                ]
              }
            ]
          }
        },
        {
          "name": "validatorRegistry",
          "writable": true
        },
        {
          "name": "payCycle",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  97,
                  121,
                  95,
                  99,
                  121,
                  99,
                  108,
                  101
                ]
              }
            ]
          }
        }
      ],
      "args": []
    }
  ],
  "accounts": [
    {
      "name": "globalStakeInfo",
      "discriminator": [
        149,
        10,
        172,
        51,
        100,
        33,
        71,
        52
      ]
    },
    {
      "name": "payCycle",
      "discriminator": [
        119,
        127,
        39,
        70,
        134,
        173,
        90,
        225
      ]
    },
    {
      "name": "payRateHistory",
      "discriminator": [
        139,
        8,
        65,
        111,
        71,
        41,
        187,
        218
      ]
    },
    {
      "name": "stakeControllerState",
      "discriminator": [
        218,
        168,
        114,
        136,
        80,
        186,
        29,
        218
      ]
    },
    {
      "name": "validatorRegistry",
      "discriminator": [
        168,
        113,
        195,
        186,
        62,
        121,
        163,
        230
      ]
    }
  ],
  "events": [
    {
      "name": "epochResolved",
      "discriminator": [
        62,
        81,
        212,
        223,
        209,
        104,
        51,
        65
      ]
    },
    {
      "name": "stakesMerged",
      "discriminator": [
        3,
        16,
        51,
        153,
        152,
        186,
        19,
        97
      ]
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "destinationAccountDoesNotExist",
      "msg": "Destination stake account does not exist"
    },
    {
      "code": 6001,
      "name": "sourceAccountDoesNotExist",
      "msg": "Source stake account does not exist"
    },
    {
      "code": 6002,
      "name": "invalidDestinationOwner",
      "msg": "Destination account not owned by stake program"
    },
    {
      "code": 6003,
      "name": "invalidSourceOwner",
      "msg": "Source account not owned by stake program"
    },
    {
      "code": 6004,
      "name": "clockBorrowFailed",
      "msg": "Failed to borrow clock data"
    },
    {
      "code": 6005,
      "name": "clockDeserializeFailed",
      "msg": "Failed to deserialize clock"
    },
    {
      "code": 6006,
      "name": "destinationAnalysisFailed",
      "msg": "Failed to analyze destination stake account"
    },
    {
      "code": 6007,
      "name": "sourceAnalysisFailed",
      "msg": "Failed to analyze source stake account"
    },
    {
      "code": 6008,
      "name": "destinationStillActivating",
      "msg": "Destination stake is still activating"
    },
    {
      "code": 6009,
      "name": "destinationDeactivating",
      "msg": "Destination stake is deactivating"
    },
    {
      "code": 6010,
      "name": "sourceStillActivating",
      "msg": "Source stake is still activating"
    },
    {
      "code": 6011,
      "name": "sourceDeactivating",
      "msg": "Source stake is deactivating"
    },
    {
      "code": 6012,
      "name": "destinationBorrowFailed",
      "msg": "Failed to borrow destination account data"
    },
    {
      "code": 6013,
      "name": "destinationParseFailed",
      "msg": "Failed to parse destination stake state"
    },
    {
      "code": 6014,
      "name": "sourceBorrowFailed",
      "msg": "Failed to borrow source account data"
    },
    {
      "code": 6015,
      "name": "sourceParseFailed",
      "msg": "Failed to parse source stake state"
    },
    {
      "code": 6016,
      "name": "differentValidators",
      "msg": "Stakes are delegated to different validators"
    },
    {
      "code": 6017,
      "name": "differentStakers",
      "msg": "Stakes have different staker authorities"
    },
    {
      "code": 6018,
      "name": "differentWithdrawers",
      "msg": "Stakes have different withdrawer authorities"
    },
    {
      "code": 6019,
      "name": "authoritiesNotFound",
      "msg": "Could not extract authorities from accounts"
    },
    {
      "code": 6020,
      "name": "mergeInstructionFailed",
      "msg": "Merge instruction failed"
    },
    {
      "code": 6021,
      "name": "epochRewardsActive",
      "msg": "Epoch rewards distribution is active - stake operations blocked"
    },
    {
      "code": 6022,
      "name": "differentCreditsObserved",
      "msg": "Stakes have different credits_observed - cannot merge until both earn same rewards"
    }
  ],
  "types": [
    {
      "name": "epochResolved",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "validator",
            "type": "pubkey"
          },
          {
            "name": "epoch",
            "type": "u64"
          },
          {
            "name": "totalStakeAmount",
            "type": "u64"
          },
          {
            "name": "maxIndex",
            "type": "u32"
          }
        ]
      }
    },
    {
      "name": "globalStakeInfo",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "currentActiveStake",
            "type": "u64"
          },
          {
            "name": "actualSystemYieldReceived",
            "type": "u64"
          },
          {
            "name": "solSystemPayRate",
            "type": "u64"
          },
          {
            "name": "totalPaidOutThisEpoch",
            "type": "u64"
          },
          {
            "name": "epochPayoutDelta",
            "type": "i64"
          },
          {
            "name": "lastUpdatedEpoch",
            "type": "u64"
          },
          {
            "name": "lastDistributionEpoch",
            "type": {
              "option": "u64"
            }
          },
          {
            "name": "lastDistributionSlot",
            "type": {
              "option": "u64"
            }
          },
          {
            "name": "lastDeactivationEpoch",
            "type": "u64"
          },
          {
            "name": "lastRebalanceEpoch",
            "type": "u64"
          },
          {
            "name": "lastMergeTransientsEpoch",
            "type": "u64"
          },
          {
            "name": "currentMergeProcessingEpoch",
            "type": "u64"
          },
          {
            "name": "validatorsProcessedThisEpoch",
            "type": "u8"
          },
          {
            "name": "validatorsMergeProcessedThisEpoch",
            "type": "u8"
          },
          {
            "name": "distributionInProgress",
            "type": "bool"
          },
          {
            "name": "transientActiveStake",
            "type": "u64"
          },
          {
            "name": "totalFeesDeposited",
            "type": "u64"
          },
          {
            "name": "totalCumulativePayout",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "payCycle",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "epoch",
            "type": "u64"
          },
          {
            "name": "totalYield",
            "type": "u64"
          },
          {
            "name": "timestamp",
            "type": "i64"
          },
          {
            "name": "fulfilled",
            "type": "bool"
          },
          {
            "name": "lastSlotPaidFor",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "payRateEntry",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "timestamp",
            "type": "i64"
          },
          {
            "name": "scaledRate",
            "type": "u64"
          }
        ]
      }
    },
    {
      "name": "payRateHistory",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "currentIndex",
            "type": "u16"
          },
          {
            "name": "totalEntriesAdded",
            "type": "u64"
          },
          {
            "name": "entries",
            "type": {
              "array": [
                {
                  "defined": {
                    "name": "payRateEntry"
                  }
                },
                50
              ]
            }
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "stakeControllerState",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "authority",
            "type": "pubkey"
          },
          {
            "name": "vaultInitialized",
            "type": "bool"
          },
          {
            "name": "reservePoolInitialized",
            "type": "bool"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    },
    {
      "name": "stakesMerged",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "validator",
            "type": "pubkey"
          },
          {
            "name": "epoch",
            "type": "u64"
          },
          {
            "name": "count",
            "type": "u32"
          },
          {
            "name": "amount",
            "type": "u64"
          }
        ]
      }
    },
    {
      "name": "validatorInfo",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "voteAccount",
            "type": "pubkey"
          },
          {
            "name": "vpp",
            "type": "u32"
          },
          {
            "name": "currentActiveStake",
            "type": "u64"
          },
          {
            "name": "epochReward",
            "type": "u64"
          },
          {
            "name": "transientActiveStake",
            "type": "u64"
          },
          {
            "name": "lastChainSyncEpoch",
            "type": "u64"
          },
          {
            "name": "lastUpdatedSlot",
            "type": "u64"
          },
          {
            "name": "maxResolvedEpochDeactivations",
            "type": "u64"
          },
          {
            "name": "maxResolvedActivatingStake",
            "type": "u64"
          }
        ]
      }
    },
    {
      "name": "validatorRegistry",
      "type": {
        "kind": "struct",
        "fields": [
          {
            "name": "authority",
            "type": "pubkey"
          },
          {
            "name": "validators",
            "type": {
              "vec": {
                "defined": {
                  "name": "validatorInfo"
                }
              }
            }
          },
          {
            "name": "lastUpdateEpoch",
            "type": "u64"
          },
          {
            "name": "bump",
            "type": "u8"
          }
        ]
      }
    }
  ]
};
