/**
 * Program IDL in camelCase format in order to be used in JS/TS.
 *
 * Note that this is only a type helper and is not the actual IDL. The original
 * IDL can be found at `target/idl/deposit.json`.
 */
export type Deposit = {
  "address": "GqksbjX3r7SHZ5e8c6nFyPecZNnBSUTYHbF8U2YDb5Qf",
  "metadata": {
    "name": "deposit",
    "version": "0.1.0",
    "spec": "0.1.0",
    "description": "Created with Anchor"
  },
  "instructions": [
    {
      "name": "deposit",
      "discriminator": [
        242,
        35,
        198,
        137,
        82,
        225,
        242,
        182
      ],
      "accounts": [
        {
          "name": "user",
          "writable": true,
          "signer": true
        },
        {
          "name": "programAuthority",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  112,
                  114,
                  111,
                  103,
                  114,
                  97,
                  109,
                  95,
                  97,
                  117,
                  116,
                  104,
                  111,
                  114,
                  105,
                  116,
                  121
                ]
              }
            ]
          }
        },
        {
          "name": "systemProgram",
          "address": "11111111111111111111111111111111"
        },
        {
          "name": "tokenProgram"
        },
        {
          "name": "associatedTokenProgram",
          "address": "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL"
        },
        {
          "name": "stakeControllerProgram",
          "address": "4Ab1SwV6RPUN5Btnf95qvQCyNVR3iHnXjnMYaKsgimTp"
        },
        {
          "name": "liqsolProgram"
        },
        {
          "name": "payRateHistory"
        },
        {
          "name": "stakeProgram",
          "address": "Stake11111111111111111111111111111111111111"
        },
        {
          "name": "distributionProgram",
          "address": "26LF4typrWwBapujpvUPFpdfs4pBb6RwcWoBBy7Awf5j"
        },
        {
          "name": "liqsolMint",
          "writable": true
        },
        {
          "name": "userAta",
          "writable": true,
          "pda": {
            "seeds": [
              {
                "kind": "account",
                "path": "user"
              },
              {
                "kind": "account",
                "path": "tokenProgram"
              },
              {
                "kind": "account",
                "path": "liqsolMint"
              }
            ],
            "program": {
              "kind": "const",
              "value": [
                140,
                151,
                37,
                143,
                78,
                36,
                137,
                241,
                187,
                61,
                16,
                41,
                20,
                142,
                13,
                131,
                11,
                90,
                19,
                153,
                218,
                255,
                16,
                132,
                4,
                142,
                123,
                216,
                219,
                233,
                248,
                89
              ]
            }
          }
        },
        {
          "name": "liqsolMintAuthority"
        },
        {
          "name": "reservePool",
          "writable": true
        },
        {
          "name": "vault",
          "writable": true
        },
        {
          "name": "ephemeralStake",
          "writable": true
        },
        {
          "name": "controllerState",
          "writable": true
        },
        {
          "name": "globalStakeInfo",
          "writable": true
        },
        {
          "name": "bucketAuthority",
          "pda": {
            "seeds": [
              {
                "kind": "const",
                "value": [
                  108,
                  105,
                  113,
                  115,
                  111,
                  108,
                  95,
                  98,
                  117,
                  99,
                  107,
                  101,
                  116
                ]
              }
            ],
            "program": {
              "kind": "account",
              "path": "stakeControllerProgram"
            }
          }
        },
        {
          "name": "bucketTokenAccount",
          "docs": [
            "The bucket's associated token account"
          ],
          "writable": true
        },
        {
          "name": "userRecord",
          "writable": true
        },
        {
          "name": "distributionState",
          "writable": true
        },
        {
          "name": "instructionsSysvar",
          "address": "Sysvar1nstructions1111111111111111111111111"
        },
        {
          "name": "clock",
          "address": "SysvarC1ock11111111111111111111111111111111"
        },
        {
          "name": "stakeHistory",
          "address": "SysvarStakeHistory1111111111111111111111111"
        },
        {
          "name": "rent",
          "address": "SysvarRent111111111111111111111111111111111"
        }
      ],
      "args": [
        {
          "name": "amount",
          "type": "u64"
        },
        {
          "name": "seed",
          "type": "u32"
        }
      ]
    }
  ],
  "errors": [
    {
      "code": 6000,
      "name": "depositTooSmall",
      "msg": "Deposit amount is below minimum required"
    },
    {
      "code": 6001,
      "name": "notInitialized",
      "msg": "Deposit Router not initialized"
    },
    {
      "code": 6002,
      "name": "invalidAuthority",
      "msg": "Invalid authority"
    },
    {
      "code": 6003,
      "name": "insufficientFunds",
      "msg": "Insufficient funds"
    },
    {
      "code": 6004,
      "name": "overflow",
      "msg": "Arithmetic overflow"
    },
    {
      "code": 6005,
      "name": "calculationFailure",
      "msg": "Calculation failure"
    },
    {
      "code": 6006,
      "name": "nothingToMint",
      "msg": "Cannot mint zero tokens"
    },
    {
      "code": 6007,
      "name": "invalidAccount",
      "msg": "Invalid account provided"
    },
    {
      "code": 6008,
      "name": "insufficientFundsForStake",
      "msg": "Insufficient funds remaining after reserving fees to proceed with staking"
    },
    {
      "code": 6009,
      "name": "unauthorizedProgram",
      "msg": "Unauthorized program attempting to call this instruction"
    }
  ]
};
